function [stats,add_tit] = get_plot_stats(varargin)

if nargin == 1
    h_f = varargin(1);
elseif nargin == 0
    h_f = gcf;
else
    error('Too many inputs to function')
end
    
h_lins = findall(h_f,'Type','Line');
if isempty(h_lins)
    warning('No plots in specified figure')
    return
end

add_tit = cell(1,1);
index = 1;
for i = length(h_lins):-1:1
    stats(i).name = h_lins(i).DisplayName;
    data = h_lins(i).YData;
    stats(i).mean = mean(data);
    stats(i).sdev = std(data);
    stats(i).pkpk = max(data)-min(data);
    col = h_lins(i).Color;
    new_line = ['\color[rgb]{' num2str(col(1)) ',' num2str(col(2)) ',' num2str(col(3)) '}' stats(i).name '\color{black} - Mean = ' num2str(stats(i).mean) ' | 1\sigma = ' num2str(stats(i).sdev) ' | Pk-Pk = ' num2str(stats(i).pkpk)];
    add_tit{index,1} = new_line;
    index = index + 1;
end

end